#include <stdio.h>
#include <i86.h>

/* get current mouse interrupt handler address */

void main()
  {
    union REGS r;
    struct SREGS s;

    s.ds = s.es = s.fs = s.gs = FP_SEG( &s );

#if defined(__PHARLAP__)
    r.w.ax = 0x2503;	/* get real-mode vector */
    r.h.cl = 0x33;	/* interrupt vector 0x33 */
    int386( 0x21, &r, &r );
    printf( "mouse handler real-mode address="
	    "%lx\n", r.x.ebx );
    r.w.ax = 0x2502;	/* get protected-mode vector */
    r.h.cl = 0x33;	/* interrupt vector 0x33 */
    int386x( 0x21, &r, &r, &s );
    printf( "mouse handler protected-mode address="
	    "%x:%lx\n", s.es, r.x.ebx );

#else
    r.h.ah = 0x35;  /* get vector */
    r.h.al = 0x33;  /* vector 0x33 */
    int386x( 0x21, &r, &r, &s );
    printf( "mouse handler protected-mode address="
	    "%x:%lx\n", s.es, r.x.ebx );
#endif
  }
